package com.yd.insurance.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiInsuranceCategoryService;
import com.yd.insurance.base.feign.client.insurancecategory.ApiInsuranceCategoryFeignClient;
import com.yd.insurance.base.feign.request.insurancecategory.ApiInsuranceCategoryAddRequest;
import com.yd.insurance.base.feign.request.insurancecategory.ApiInsuranceCategoryPageRequest;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryDetailResponse;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryEditRequest;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 保险险种信息
 *
 * @author zxm
 * @since 2025-12-22
 */
@RestController
@RequestMapping("/insuranceCategory")
@Validated
public class ApiInsuranceCategoryController implements ApiInsuranceCategoryFeignClient {

    @Autowired
    private ApiInsuranceCategoryService apiInsuranceCategoryService;

    /**
     * 分页列表查询-保险险种信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiInsuranceCategoryPageResponse>> page(ApiInsuranceCategoryPageRequest request) {
        return apiInsuranceCategoryService.page(request);
    }

    /**
     * 详情-保险险种信息
     * @param insuranceCategoryBizId 保险险种表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiInsuranceCategoryDetailResponse> detail(String insuranceCategoryBizId) {
        return apiInsuranceCategoryService.detail(insuranceCategoryBizId);
    }

    /**
     * 添加-保险险种信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiInsuranceCategoryAddRequest request) {
        return apiInsuranceCategoryService.add(request);
    }

    /**
     * 编辑-保险险种信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiInsuranceCategoryEditRequest request) {
        return apiInsuranceCategoryService.edit(request);
    }

    /**
     * 删除-保险险种信息
     * @param insuranceCategoryBizId 保险险种表唯一业务ID
     * @return
     */
    @Override
    public Result del(String insuranceCategoryBizId) {
        return apiInsuranceCategoryService.del(insuranceCategoryBizId);
    }

    /**
     * 编辑-保险险种信息状态
     * @param insuranceCategoryBizId 保险险种表唯一业务ID
     * @param status 状态(0:停用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String insuranceCategoryBizId, String status) {
        return apiInsuranceCategoryService.editStatus(insuranceCategoryBizId,status);
    }
}
