package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保险公司缴费信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-22
 */
@Getter
@Setter
@TableName("insurance_company_payment")
public class InsuranceCompanyPayment implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险公司缴费信息表唯一业务ID
     */
    @TableField("insurance_company_payment_biz_id")
    private String insuranceCompanyPaymentBizId;

    /**
     * 保险公司表唯一业务ID
     */
    @TableField("insurance_company_biz_id")
    private String insuranceCompanyBizId;

    /**
     * 银行中文名
     */
    @TableField("bank_cn_name")
    private String bankCnName;

    /**
     * 银行英文名
     */
    @TableField("bank_en_name")
    private String bankEnName;

    /**
     * 银行地址
     */
    @TableField("bank_address")
    private String bankAddress;

    /**
     * SWIFT CODE
     */
    @TableField("swift_code")
    private String swiftCode;

    /**
     * 港币收款账号
     */
    @TableField("hkd_collection_account")
    private String hkdCollectionAccount;

    /**
     * 美元收款账号
     */
    @TableField("usd_collection_account")
    private String usdCollectionAccount;

    /**
     * 人民币收款账号
     */
    @TableField("rmb_collection_account")
    private String rmbCollectionAccount;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
