package com.yd.insurance.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiInsuranceProductPlanService;
import com.yd.insurance.base.feign.client.ApiInsuranceProductPlanFeignClient;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanAddRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanEditRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPlanDetailResponse;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPlanPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 保险产品计划信息
 *
 * @author zxm
 * @since 2025-08-25
 */
@RestController
@RequestMapping("/insuranceProductPlan")
@Validated
public class ApiInsuranceProductPlanController implements ApiInsuranceProductPlanFeignClient {

    @Autowired
    private ApiInsuranceProductPlanService apiInsuranceProductPlanService;

    /**
     * 保险产品计划分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiInsuranceProductPlanPageResponse>> page(ApiInsuranceProductPlanPageRequest request) {
        return apiInsuranceProductPlanService.page(request);
    }

    /**
     * 获取保险产品计划详情
     * @param planBizId 保险产品计划唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiInsuranceProductPlanDetailResponse> detail(String planBizId) {
        return apiInsuranceProductPlanService.detail(planBizId);
    }

    /**
     * 添加保险产品计划
     * @param request
     * @return
     */
    @Override
    public Result add(ApiInsuranceProductPlanAddRequest request) {
        return apiInsuranceProductPlanService.add(request);
    }

    /**
     * 编辑保险产品计划
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiInsuranceProductPlanEditRequest request) {
        return apiInsuranceProductPlanService.edit(request);
    }

    /**
     * 删除保险产品计划（逻辑删除）
     * @param planBizId 保险产品计划唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String planBizId) {
        return apiInsuranceProductPlanService.detail(planBizId);
    }

    /**
     * 编辑保险产品计划状态
     * @param planBizId 保险产品计划唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String planBizId, Integer status) {
        return apiInsuranceProductPlanService.editStatus(planBizId,status);
    }
}
