package com.yd.insurance.base.feign.fallback;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.client.ApiInsuranceProductPlanFeignClient;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanAddRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanEditRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPlanDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 保险基础数据服务-保险产品计划信息Feign降级处理
 */
@Slf4j
@Component
public class ApiInsuranceProductPlanFeignFallbackFactory implements FallbackFactory<ApiInsuranceProductPlanFeignClient> {
    @Override
    public ApiInsuranceProductPlanFeignClient create(Throwable cause) {
        return new ApiInsuranceProductPlanFeignClient() {
            @Override
            public Result page(ApiInsuranceProductPlanPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiInsuranceProductPlanDetailResponse> detail(String planBizId) {
                return null;
            }

            @Override
            public Result add(ApiInsuranceProductPlanAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiInsuranceProductPlanEditRequest request) {
                return null;
            }

            @Override
            public Result del(String planBizId) {
                return null;
            }

            @Override
            public Result editStatus(String planBizId,Integer status) {
                return null;
            }
        };
    }
}
