package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPageResponse;
import com.yd.insurance.base.service.dto.InsuranceProductDto;
import com.yd.insurance.base.service.model.InsuranceProduct;
import com.yd.insurance.base.service.dao.InsuranceProductMapper;
import com.yd.insurance.base.service.service.IInsuranceProductService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.user.service.model.SysDept;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 保险产品基础表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */

@Slf4j
@Primary
@Service
public class InsuranceProductServiceImpl extends ServiceImpl<InsuranceProductMapper, InsuranceProduct> implements IInsuranceProductService {


    @Override
    public IPage<ApiInsuranceProductPageResponse> page(Page<ApiInsuranceProductPageResponse> page,
                                                       ApiInsuranceProductPageRequest request,
                                                       Boolean isAdmin,
                                                       List<String> projectBizIdList,
                                                       String loginTenantBizId) {
        return baseMapper.page(page,request,isAdmin,projectBizIdList,loginTenantBizId);
    }

    /**
     * 查询单个对象
     * @param productBizId
     * @return
     */
    @Override
    public InsuranceProduct queryOne(String productBizId) {
        return this.getOne(new LambdaQueryWrapper<InsuranceProduct>().eq(InsuranceProduct::getProductBizId,productBizId));
    }

    @Override
    public List<InsuranceProduct> queryList(InsuranceProductDto dto) {
        List<InsuranceProduct> list = baseMapper.selectList(new LambdaQueryWrapper<InsuranceProduct>()
                .eq(!Objects.isNull(dto.getId()),InsuranceProduct::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getProductBizId()) && !dto.getIsExcludeMy(),InsuranceProduct::getProductBizId,dto.getProductBizId())
                .eq(StringUtils.isNotBlank(dto.getProductName()),InsuranceProduct::getProductName,dto.getProductName())
                .in(!CollectionUtils.isEmpty(dto.getProductBizIdList()),InsuranceProduct::getProductBizId,dto.getProductBizIdList())
                .in(!CollectionUtils.isEmpty(dto.getProductCodeList()),InsuranceProduct::getProductCode,dto.getProductCodeList())
                .ne(dto.getIsExcludeMy(),InsuranceProduct::getProductBizId,dto.getProductBizId())
        );
        return list;
    }
}
