package com.yd.insurance.base.feign.client.insurancecategory;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.fallback.insurancecategory.ApiInsuranceCategoryFeignFallbackFactory;
import com.yd.insurance.base.feign.request.insurancecategory.ApiInsuranceCategoryAddRequest;
import com.yd.insurance.base.feign.request.insurancecategory.ApiInsuranceCategoryPageRequest;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryDetailResponse;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryEditRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 保险险种信息Feign客户端
 */
@FeignClient(name = "yd-user-api",path = "/insurance/base/api/insuranceCategory",fallbackFactory = ApiInsuranceCategoryFeignFallbackFactory.class)
public interface ApiInsuranceCategoryFeignClient {

    /**
     * 分页列表查询-保险险种信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiInsuranceCategoryPageRequest request);

    /**
     * 详情-保险险种信息
     * @param insuranceCategoryBizId 保险险种表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiInsuranceCategoryDetailResponse> detail(@NotBlank(message = "保险险种表唯一业务ID不能为空") @RequestParam(value = "insuranceCategoryBizId") String insuranceCategoryBizId);

    /**
     * 添加-保险险种信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiInsuranceCategoryAddRequest request);

    /**
     * 编辑-保险险种信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiInsuranceCategoryEditRequest request);


    /**
     * 删除-保险险种信息
     * @param insuranceCategoryBizId 保险险种表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "insuranceCategoryBizId") String insuranceCategoryBizId);

    /**
     * 编辑-保险险种信息状态
     * @param insuranceCategoryBizId 保险险种表唯一业务ID
     * @param status 状态(0:停用 1:启用)
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "保险险种表唯一业务ID不能为空") @RequestParam(value = "insuranceCategoryBizId") String insuranceCategoryBizId,
                      @NotBlank(message = "状态不能为空") @RequestParam(value = "status") String status);
}
