package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPlanPageResponse;
import com.yd.insurance.base.service.dto.InsuranceProductPlanDto;
import com.yd.insurance.base.service.model.InsuranceProduct;
import com.yd.insurance.base.service.model.InsuranceProductPlan;
import com.yd.insurance.base.service.dao.InsuranceProductPlanMapper;
import com.yd.insurance.base.service.model.RelInsuranceProductPlan;
import com.yd.insurance.base.service.service.IInsuranceProductPlanService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 保险产品计划表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */

@Slf4j
@Primary
@Service
public class InsuranceProductPlanServiceImpl extends ServiceImpl<InsuranceProductPlanMapper, InsuranceProductPlan> implements IInsuranceProductPlanService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<InsuranceProductPlan> queryList(InsuranceProductPlanDto dto) {
        List<InsuranceProductPlan> list = baseMapper.selectList(new LambdaQueryWrapper<InsuranceProductPlan>()
                .eq(!Objects.isNull(dto.getId()),InsuranceProductPlan::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getPlanBizId()) && !dto.getIsExcludeMy(),InsuranceProductPlan::getPlanBizId,dto.getPlanBizId())
                .eq(StringUtils.isNotBlank(dto.getPlanName()),InsuranceProductPlan::getPlanName,dto.getPlanName())
                .in(!CollectionUtils.isEmpty(dto.getPlanBizIdList()),InsuranceProductPlan::getPlanBizId,dto.getPlanBizIdList())
                .ne(dto.getIsExcludeMy(),InsuranceProductPlan::getPlanBizId,dto.getPlanBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param planBizId
     * @return
     */
    @Override
    public InsuranceProductPlan queryOne(String planBizId) {
        return this.getOne(new LambdaQueryWrapper<InsuranceProductPlan>().eq(InsuranceProductPlan::getPlanBizId,planBizId));
    }

    @Override
    public IPage<ApiInsuranceProductPlanPageResponse> page(Page<ApiInsuranceProductPlanPageResponse> page,
                                                           ApiInsuranceProductPlanPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public Boolean removeByPlanBizId(String planBizId) {
        return this.remove(new LambdaQueryWrapper<InsuranceProductPlan>().eq(InsuranceProductPlan::getPlanBizId,planBizId));
    }
}
