package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保险对账公司表
 * </p>
 *
 * @author zxm
 * @since 2025-12-23
 */
@Getter
@Setter
@TableName("insurance_reconciliation_company")
public class InsuranceReconciliationCompany implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险对账公司表唯一业务ID
     */
    @TableField("reconciliation_company_biz_id")
    private String reconciliationCompanyBizId;

    /**
     * 部门组织表唯一业务ID
     */
    @TableField("dept_biz_id")
    private String deptBizId;

    /**
     * 保险对账公司名称
     */
    @TableField("name")
    private String name;

    /**
     * 保险对账公司编码
     */
    @TableField("code")
    private String code;

    /**
     * 合同起期
     */
    @TableField("contract_start_date")
    private LocalDateTime contractStartDate;

    /**
     * 合同止期
     */
    @TableField("contract_end_date")
    private LocalDateTime contractEndDate;

    /**
     * 对接人姓名
     */
    @TableField("dock_name")
    private String dockName;

    /**
     * 对接人手机号
     */
    @TableField("dock_phone")
    private String dockPhone;

    /**
     * 对接人邮箱
     */
    @TableField("dock_email")
    private String dockEmail;

    /**
     * 对接人微信二维码
     */
    @TableField("dock_wx_code")
    private String dockWxCode;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
