package com.yd.insurance.base.feign.client;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.fallback.ApiInsuranceAdditionalProductFeignFallbackFactory;
import com.yd.insurance.base.feign.request.*;
import com.yd.insurance.base.feign.response.ApiInsuranceAdditionalProductDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 保险基础数据服务-保险附加产品基础信息Feign客户端
 */
@FeignClient(name = "yd-insurance-base-api", fallbackFactory = ApiInsuranceAdditionalProductFeignFallbackFactory.class)
public interface ApiInsuranceAdditionalProductFeignClient {

    /**
     * 保险附加产品分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiInsuranceAdditionalProductPageRequest request);

    /**
     * 获取保险附加产品详情
     * @param additionalProductBizId 保险附加产品唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiInsuranceAdditionalProductDetailResponse> detail(@NotBlank(message = "保险附加产品唯一标识(业务ID)不能为空") @RequestParam(value = "additionalProductBizId") String additionalProductBizId);

    /**
     * 添加保险附加产品
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiInsuranceAdditionalProductAddRequest request);

    /**
     * 编辑保险附加产品
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiInsuranceAdditionalProductEditRequest request);


    /**
     * 删除保险附加产品（逻辑删除）
     * @param additionalProductBizId 保险附加产品唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "additionalProductBizId") String additionalProductBizId);

    /**
     * 编辑保险附加产品状态
     * @param additionalProductBizId 保险附加产品唯一标识(业务ID)
     * @param status '保险附加产品状态：0=下架，1=在售'
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "保险附加产品唯一标识(业务ID)不能为空") @RequestParam(value = "additionalProductBizId") String additionalProductBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);
}
