package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.insurance.base.service.model.RelInsuranceProductPlan;
import com.yd.insurance.base.service.dao.RelInsuranceProductPlanMapper;
import com.yd.insurance.base.service.service.IRelInsuranceProductPlanService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.user.service.model.SysDept;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 保险产品-保险产品计划关联表（支撑多产品组合计划） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */

@Slf4j
@Primary
@Service
public class RelInsuranceProductPlanServiceImpl extends ServiceImpl<RelInsuranceProductPlanMapper, RelInsuranceProductPlan> implements IRelInsuranceProductPlanService {

    /**
     * 根据保险产品id删除关系
     * @param productBizId
     * @return
     */
    @Override
    public Boolean removeByProductBizId(String productBizId) {
        return this.remove(new LambdaQueryWrapper<RelInsuranceProductPlan>().eq(RelInsuranceProductPlan::getProductBizId,productBizId));
    }

    /**
     * 查询关系列表
     * @param productBizId
     * @return
     */
    @Override
    public List<RelInsuranceProductPlan> queryList(String productBizId) {
        List<RelInsuranceProductPlan> list = baseMapper.selectList(new LambdaQueryWrapper<RelInsuranceProductPlan>()
                .eq(StringUtils.isNotBlank(productBizId),RelInsuranceProductPlan::getProductBizId,productBizId)
        );
        return list;
    }

}
