package com.yd.insurance.base.feign.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiInsuranceProductPlanAddRequest {

    /**
     * 保险产品计划名称
     */
    @NotBlank(message = "保险产品计划名称不能为空")
    private String planName;

    /**
     * 状态(0:禁用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 产品计划图片
     */
    private String picture;
}
