package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保险险种表
 * </p>
 *
 * @author zxm
 * @since 2025-12-22
 */
@Getter
@Setter
@TableName("insurance_category")
public class InsuranceCategory implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险险种表唯一业务ID
     */
    @TableField("insurance_category_biz_id")
    private String insuranceCategoryBizId;

    /**
     * 分类类别（区分是国内还是港险还是通用）
     */
    @TableField("type")
    private String type;

    /**
     * 分类编码
     */
    @TableField("code")
    private String code;

    /**
     * 分类名称（分类名称，中文显示名称。例如：储蓄险，医疗险，意外险。）
     */
    @TableField("name")
    private String name;

    /**
     * 父级id
     */
    @TableField("pid")
    private String pid;

    /**
     * 分类层级
     */
    @TableField("level")
    private Integer level;

    /**
     * 排序
     */
    @TableField("sort_order")
    private Integer sortOrder;

    /**
     * 图标链接。存储该类别的图标或图片URL，用于前端展示。
     */
    @TableField("icon_url")
    private String iconUrl;

    /**
     * 父子路径
     */
    @TableField("path")
    private String path;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 分类描述（分类描述，详细说明此分类的范围和特点。）
     */
    @TableField("description")
    private String description;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
