package com.yd.insurance.base.feign.response.usersignexpand;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiUserSignExpandDetailResponse {

    /**
     * 签单用户扩展主键ID
     */
    private Long id;

    /**
     * 签单用户扩展唯一业务ID
     */
    private String userSignBizId;

    /**
     * 系统用户唯一标识(业务ID)
     */
    private String userBizId;

    /**
     * 签单用户真实姓名
     */
    private String realName;

    /**
     * 执业编码
     */
    private String practiceCode;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 证件类型
     */
    private String cardType;

    /**
     * 证件号码
     */
    private String cardNo;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
