package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.insurance.base.service.dto.RelProductAnnouncementDto;
import com.yd.insurance.base.service.model.InsuranceProduct;
import com.yd.insurance.base.service.model.RelProductAnnouncement;
import com.yd.insurance.base.service.dao.RelProductAnnouncementMapper;
import com.yd.insurance.base.service.service.IRelProductAnnouncementService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 产品和公告比例关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-28
 */
@Service
public class RelProductAnnouncementServiceImpl extends ServiceImpl<RelProductAnnouncementMapper, RelProductAnnouncement> implements IRelProductAnnouncementService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RelProductAnnouncement> queryList(RelProductAnnouncementDto dto) {
        List<RelProductAnnouncement> list = baseMapper.selectList(new LambdaQueryWrapper<RelProductAnnouncement>()
                .in(!CollectionUtils.isEmpty(dto.getProductBizIdList()),RelProductAnnouncement::getProductBizId,dto.getProductBizIdList())
                .in(!CollectionUtils.isEmpty(dto.getProductCodeList()),RelProductAnnouncement::getProductCode,dto.getProductCodeList())
        );
        return list;
    }
}
