package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保险公司联系信息表
 * </p>
 *
 * @author zxm
 * @since 2025-12-22
 */
@Getter
@Setter
@TableName("insurance_company_contact")
public class InsuranceCompanyContact implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险公司联系信息表唯一业务ID
     */
    @TableField("insurance_company_contact_biz_id")
    private String insuranceCompanyContactBizId;

    /**
     * 保险公司表唯一业务ID
     */
    @TableField("insurance_company_biz_id")
    private String insuranceCompanyBizId;

    /**
     * 联系类型（客服、理赔、核保、投诉、其他）
     */
    @TableField("contact_type")
    private String contactType;

    /**
     * 联系电话
     */
    @TableField("contact_phone")
    private String contactPhone;

    /**
     * 联系邮箱
     */
    @TableField("contact_email")
    private String contactEmail;

    /**
     * 联系微信
     */
    @TableField("contact_wechat")
    private String contactWechat;

    /**
     * 公众号名称
     */
    @TableField("official_account_name")
    private String officialAccountName;

    /**
     * 公众号二维码
     */
    @TableField("official_account_qr_code")
    private String officialAccountQrCode;

    /**
     * 网站地址
     */
    @TableField("website_address")
    private String websiteAddress;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
