package com.yd.insurance.base.feign.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Data
public class ApiInsuranceProductAddRequest {

    /**
     * 保险产品名称
     */
    @NotBlank(message = "保险产品名称不能为空")
    private String productName;

    /**
     * 保险产品类型
     */
    @NotBlank(message = "保险产品类型不能为空")
    private String productType;

    /**
     * 支持货币
     */
    @NotBlank(message = "支持货币不能为空")
    private String currency;

    /**
     * 受保年龄范围
     */
    @NotBlank(message = "受保年龄范围不能为空")
    private String insuredAgeRange;

    /**
     * 是否区分吸烟：0=不区分，1=区分
     */
    @NotNull(message = "是否区分吸烟不能为空")
    private Integer smokingAllowed;

    /**
     * 保障内容
     */
    @NotBlank(message = "保障内容不能为空")
    private String coverageContent;

    /**
     * 基础费率
     */
    @NotNull(message = "基础费率不能为空")
    private BigDecimal premiumRate;

    /**
     * 保险产品状态：0=下架，1=在售
     */
    @NotNull(message = "保险产品状态不能为空")
    private Integer productStatus;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    @NotNull(message = "作用域不能为空")
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;

    /**
     * 绑定产品所属保险公司唯一业务ID列表（部门id集合）
     */
    @NotEmpty(message = "绑定产品所属保险公司唯一业务ID列表（部门id集合）不能为空")
    private List<String> ssDeptBizIdList;

    /**
     * 绑定供款年期列表
     */
    @NotEmpty(message = "绑定供款年期列表不能为空")
    private List<String> paymentTermList;

    /**
     * 绑定保险产品出单公司唯一业务ID列表（部门id集合）
     */
    private List<String> cdDeptBizIdList;

    /**
     * 绑定保险产品计划唯一业务ID列表
     */
    private List<String> planBizIdList;

    /**
     * 绑定保险附加产品唯一业务ID列表
     */
    private List<String> additionalProductBizIdList;

    /**
     * 产品图片
     */
    private String picture;

    /**
     * 产品所属公司的所在地
     */
    private String location;
}
