package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保险公司表
 * </p>
 *
 * @author zxm
 * @since 2025-12-22
 */
@Getter
@Setter
@TableName("insurance_company")
public class InsuranceCompany implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险公司表唯一业务ID
     */
    @TableField("insurance_company_biz_id")
    private String insuranceCompanyBizId;

    /**
     * 部门组织表唯一业务ID
     */
    @TableField("dept_biz_id")
    private String deptBizId;

    /**
     * 保险公司编码
     */
    @TableField("code")
    private String code;

    /**
     * 保险公司全称
     */
    @TableField("full_name")
    private String fullName;

    /**
     * 保险公司简称
     */
    @TableField("abbreviation")
    private String abbreviation;

    /**
     * 保险公司英文全称
     */
    @TableField("en_full_name")
    private String enFullName;

    /**
     * 保险公司英文简称
     */
    @TableField("en_abbreviation")
    private String enAbbreviation;

    /**
     * 保险公司类型（财险、寿险、健康险、综合）
     */
    @TableField("type")
    private String type;

    /**
     * 所属地区
     */
    @TableField("region")
    private String region;

    /**
     * 保险公司介绍（支持HTML）
     */
    @TableField("introduction")
    private String introduction;

    /**
     * 联系电话
     */
    @TableField("contact_phone")
    private String contactPhone;

    /**
     * 联系邮箱
     */
    @TableField("contact_email")
    private String contactEmail;

    /**
     * 官方网站
     */
    @TableField("official_website")
    private String officialWebsite;

    /**
     * 公众号名称
     */
    @TableField("official_account_name")
    private String officialAccountName;

    /**
     * 公众号二维码
     */
    @TableField("official_account_qr_code")
    private String officialAccountQrCode;

    /**
     * 合作状态（合作中、已终止、未合作）
     */
    @TableField("cooperation_status")
    private String cooperationStatus;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
