package com.yd.insurance.base.feign.response.usersaleexpand;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiUserSaleExpandDetailResponse {

    /**
     * 销售用户扩展表主键ID
     */
    private Long id;

    /**
     * 销售用户扩展唯一业务ID
     */
    private String userSaleBizId;

    /**
     * 系统用户唯一标识(业务ID)
     */
    private String userBizId;

    /**
     * 客户端用户表唯一业务ID
     */
    private String clientUserBizId;

    /**
     * 销售用户真实姓名
     */
    private String realName;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 性别(0:未知 1:男 2:女)
     */
    private Integer gender;

    /**
     * 内部编号
     */
    private String internalNumber;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
