package com.yd.insurance.base.feign.response.insurancecategory;

import lombok.Data;

@Data
public class ApiInsuranceCategoryPageResponse {

    /**
     * 保险险种表主键ID
     */
    private Long id;

    /**
     * 保险险种表唯一业务ID
     */
    private String insuranceCategoryBizId;

    /**
     * 分类类别（区分是国内还是港险还是通用）
     */
    private String type;

    /**
     * 分类编码
     */
    private String code;

    /**
     * 分类名称（分类名称，中文显示名称。例如：储蓄险，医疗险，意外险。）
     */
    private String name;

    /**
     * 父级id
     */
    private String pid;

    /**
     * 分类层级
     */
    private Integer level;

    /**
     * 排序
     */
    private Integer sortOrder;

    /**
     * 图标链接。存储该类别的图标或图片URL，用于前端展示。
     */
    private String iconUrl;

    /**
     * 父子路径
     */
    private String path;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 分类描述（分类描述，详细说明此分类的范围和特点。）
     */
    private String description;
}
