package com.yd.insurance.base.feign.client.insurancereconciliationcompany;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.fallback.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyFeignFallbackFactory;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyAddRequest;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyEditRequest;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyPageRequest;
import com.yd.insurance.base.feign.response.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 保险对账公司信息Feign客户端
 */
@FeignClient(name = "yd-insurance-base-api",path = "/insurance/base/api/insuranceReconciliationCompany",fallbackFactory = ApiInsuranceReconciliationCompanyFeignFallbackFactory.class)
public interface ApiInsuranceReconciliationCompanyFeignClient {

    /**
     * 分页列表查询-保险对账公司信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiInsuranceReconciliationCompanyPageRequest request);

    /**
     * 详情-保险对账公司信息
     * @param reconciliationCompanyBizId 保险对账公司唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiInsuranceReconciliationCompanyDetailResponse> detail(@NotBlank(message = "保险对账公司唯一业务ID不能为空") @RequestParam(value = "reconciliationCompanyBizId") String reconciliationCompanyBizId);

    /**
     * 添加-保险对账公司信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiInsuranceReconciliationCompanyAddRequest request);

    /**
     * 编辑-保险对账公司信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiInsuranceReconciliationCompanyEditRequest request);


    /**
     * 删除-保险对账公司信息
     * @param reconciliationCompanyBizId 保险对账公司唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "reconciliationCompanyBizId") String reconciliationCompanyBizId);

    /**
     * 编辑-保险对账公司信息状态
     * @param reconciliationCompanyBizId 保险对账公司唯一业务ID
     * @param status 状态(0:停用 1:启用)
     * @return
     */
    @PatchMapping("/edit/cooperationStatus")
    Result editStatus(@NotBlank(message = "保险对账公司唯一业务ID不能为空") @RequestParam(value = "reconciliationCompanyBizId") String reconciliationCompanyBizId,
                      @NotBlank(message = "状态不能为空") @RequestParam(value = "status") String status);
}
