package com.yd.insurance.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiInsuranceReconciliationCompanyService;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyAddRequest;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyEditRequest;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyPageRequest;
import com.yd.insurance.base.feign.response.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyDetailResponse;
import com.yd.insurance.base.feign.response.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyPageResponse;
import com.yd.insurance.base.service.service.IInsuranceReconciliationCompanyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class ApiInsuranceReconciliationCompanyServiceImpl implements ApiInsuranceReconciliationCompanyService {

    @Autowired
    private IInsuranceReconciliationCompanyService iInsuranceReconciliationCompanyService;

    /**
     * 分页列表查询-保险对账公司信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiInsuranceReconciliationCompanyPageResponse>> page(ApiInsuranceReconciliationCompanyPageRequest request) {
        Page<ApiInsuranceReconciliationCompanyPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiInsuranceReconciliationCompanyPageResponse> iPage = iInsuranceReconciliationCompanyService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 详情-保险对账公司信息
     * @param reconciliationCompanyBizId 保险对账公司唯一业务ID
     * @return
     */
    @Override
    public Result<ApiInsuranceReconciliationCompanyDetailResponse> detail(String reconciliationCompanyBizId) {
        return null;
    }

    /**
     * 添加-保险对账公司信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiInsuranceReconciliationCompanyAddRequest request) {
        return null;
    }

    /**
     * 编辑-保险对账公司信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiInsuranceReconciliationCompanyEditRequest request) {
        return null;
    }

    /**
     * 删除-保险对账公司信息
     * @param reconciliationCompanyBizId 保险对账公司唯一业务ID
     * @return
     */
    @Override
    public Result del(String reconciliationCompanyBizId) {
        return null;
    }

    /**
     * 编辑-保险对账公司信息状态
     * @param reconciliationCompanyBizId 保险对账公司唯一业务ID
     * @param status 状态(0:停用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String reconciliationCompanyBizId, String status) {
        return null;
    }

}
