package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailVariableFeignFallbackFactory;
import com.yd.email.feign.request.ApiEmailVariableAddRequest;
import com.yd.email.feign.request.ApiEmailVariableEditRequest;
import com.yd.email.feign.request.ApiEmailVariablePageRequest;
import com.yd.email.feign.response.ApiEmailVariableDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 邮箱服务-变量信息（邮件内容占位符）Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailVariableFeignFallbackFactory.class)
public interface ApiEmailVariableFeignClient {

    /**
     * 分页查询-变量
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiEmailVariablePageRequest request);

    /**
     * 添加-变量
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiEmailVariableAddRequest request);

    /**
     * 编辑-变量
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiEmailVariableEditRequest request);

    /**
     * 详情-变量
     * @param variableBizId 变量唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiEmailVariableDetailResponse> detail(@RequestParam(value = "variableBizId") String variableBizId);

    /**
     * 删除-变量
     * @param variableBizId 变量唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "variableBizId") String variableBizId);
}
