package com.yd.email.feign.request;

import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 添加-发件人配置入参
 */
@Data
public class ApiEmailSenderConfigAddRequest {

    /**
     * 邮箱地址
     */
    @NotBlank(message = "邮箱地址不能为空")
    @Email(message = "邮箱格式不正确")
    private String email;

    /**
     * 邮箱密码或授权码
     */
    @NotBlank(message = "邮箱密码或授权码不能为空")
    private String password;

    /**
     * 绑定的邮箱服务商唯一业务ID
     */
    @NotBlank(message = "绑定的邮箱服务商唯一业务ID不能为空")
    private String providerBizId;

    /**
     * 发件人显示名称（姓名/昵称）
     */
//    @NotBlank(message = "发件人显示名称不能为空")
    private String displayName;

    /**
     * 是否启用该配置: 0-否, 1-是（字典）
     */
    @NotNull(message = "是否启用该配置不能为空")
    private Integer active;

}
