package com.yd.email.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * SMTP邮箱服务商配置表（存储不同邮箱服务商的SMTP配置信息）
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Getter
@Setter
@TableName("email_provider_config")
public class EmailProviderConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 邮箱服务商唯一业务ID
     */
    @TableField("provider_biz_id")
    private String providerBizId;

    /**
     * 邮箱服务商名称
     */
    @TableField("provider_name")
    private String providerName;

    /**
     * SMTP服务器地址
     */
    @TableField("smtp_host")
    private String smtpHost;

    /**
     * SMTP服务器端口
     */
    @TableField("smtp_port")
    private Integer smtpPort;

    /**
     * 是否启用SSL加密: 0-否, 1-是
     */
    @TableField("ssl_enabled")
    private Integer sslEnabled;

    /**
     * 配置描述
     */
    @TableField("description")
    private String description;

    /**
     * 是否为默认配置: 0-否, 1-是
     */
    @TableField("is_default")
    private Integer isDefault;

    /**
     * 是否启用: 0-否, 1-是
     */
    @TableField("is_active")
    private Integer isActive;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
