package com.yd.email.feign.response;

import lombok.Data;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiEmailContactImportResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 导入临时表唯一业务ID
     */
    private String importBizId;

    /**
     * 当前会话id（前端使用，用于查询。存于前端缓存）
     */
    private String sessionId;

    /**
     * 收件人唯一业务ID（联系人唯一业务ID，导入excel无值，选择联系人有值）
     */
    private String contactBizId;

    /**
     * 收件人邮箱（单个）
     */
    private String receiveEmail;

    /**
     * 抄送人邮箱（数组）
     */
    private List<String> ccEmailList;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
