package com.yd.email.feign.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiEmailProviderConfigEditRequest {

//    /**
//     * 邮箱服务商主键ID
//     */
//    @NotNull(message = "邮箱服务商主键ID不能为空")
//    private Long id;

    /**
     * 邮箱服务商唯一业务ID
     */
    @NotBlank(message = "邮箱服务商唯一业务ID不能为空")
    private String providerBizId;

    /**
     * 邮箱服务商名称
     */
    @NotBlank(message = "邮箱服务商名称不能为空")
    private String providerName;

    /**
     * SMTP服务器地址
     */
    @NotBlank(message = "SMTP服务器地址不能为空")
    private String smtpHost;

    /**
     * SMTP服务器端口
     */
    @NotNull(message = "SMTP服务器端口不能为空")
    private Integer smtpPort;

    /**
     * 是否启用SSL加密: 0-否, 1-是
     */
    @NotNull(message = "是否启用SSL加密不能为空")
    private Integer sslEnabled;

    /**
     * 配置描述
     */
    private String description;

    /**
     * 是否启用: 0-否, 1-是
     */
    @NotNull(message = "是否启用不能为空")
    private Integer isActive;

}
