package com.yd.email.feign.enums;

/**
 * 邮件任务状态枚举
 */
public enum EmailTaskStatusEnum {

    PENDING("待发送","PENDING"),
    SENDING("发送中","SENDING"),
    SUCCESSFUL("发送成功","SUCCESSFUL"),
    FAILED("发送失败","FAILED"),
    CANCELLED("已取消","CANCELLED"),
    SCHEDULED("已定时","SCHEDULED"),
    ALL_SUCCESSFUL("全部发送成功","ALL_SUCCESSFUL"),
    ALL_FAILED("全部发送失败","ALL_FAILED"),
    PARTIALLY_SUCCESSFUL("部分发送成功","PARTIALLY_SUCCESSFUL"),
    PARTIAL_FAILURE("部分发送失败","PARTIAL_FAILURE"),
    ;

    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    EmailTaskStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
