package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailSenderConfigFeignFallbackFactory;
import com.yd.email.feign.request.ApiEmailSenderConfigAddRequest;
import com.yd.email.feign.request.ApiEmailSenderConfigEditRequest;
import com.yd.email.feign.request.ApiEmailSenderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailSenderConfigDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 邮箱服务-发件人配置信息Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailSenderConfigFeignFallbackFactory.class)
public interface ApiEmailSenderConfigFeignClient {

    /**
     * 分页查询-发件人
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiEmailSenderConfigPageRequest request);

    /**
     * 添加-发件人配置
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiEmailSenderConfigAddRequest request);

    /**
     * 编辑-发件人配置
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiEmailSenderConfigEditRequest request);

    /**
     * 详情-发件人
     * @param senderBizId 发件人唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiEmailSenderConfigDetailResponse> detail(@RequestParam(value = "senderBizId") String senderBizId);

    /**
     * 删除-发件人
     * @param senderBizId 发件人唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "senderBizId") String senderBizId);
}
