package com.yd.email.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailContactService;
import com.yd.email.feign.client.ApiEmailContactFeignClient;
import com.yd.email.feign.request.ApiEmailContactAddRequest;
import com.yd.email.feign.request.ApiEmailContactEditRequest;
import com.yd.email.feign.request.ApiEmailContactPageRequest;
import com.yd.email.feign.response.ApiEmailContactDetailResponse;
import com.yd.email.feign.response.ApiEmailContactPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 联系人信息（存储收件人信息）
 *
 * @author zxm
 * @since 2025-09-19
 */
@RestController
@RequestMapping("/emailContact")
@Validated
public class ApiEmailContactController implements ApiEmailContactFeignClient {

    @Autowired
    private ApiEmailContactService apiEmailContactService;

    /**
     * 分页查询-联系人（收件人）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailContactPageResponse>> page(ApiEmailContactPageRequest request) {
        return apiEmailContactService.page(request);
    }

    /**
     * 添加-联系人（收件人）配置
     * @param request
     * @return
     */
    @Override
    public Result add(ApiEmailContactAddRequest request) {
        return apiEmailContactService.add(request);
    }

    /**
     * 编辑-联系人（收件人）配置
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiEmailContactEditRequest request) {
        return apiEmailContactService.edit(request);
    }

    /**
     * 详情-联系人（收件人）
     * @param contactBizId 联系人（收件人）唯一业务ID
     * @return
     */
    @Override
    public Result<ApiEmailContactDetailResponse> detail(String contactBizId) {
        return apiEmailContactService.detail(contactBizId);
    }

    /**
     * 删除-联系人（收件人）
     * @param contactBizId 联系人（收件人）唯一业务ID
     * @return
     */
    @Override
    public Result del(String contactBizId) {
        return apiEmailContactService.del(contactBizId);
    }
}
