package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailContactImportFeignFallbackFactory;
import com.yd.email.feign.request.ApiEmailContactImportEditRequest;
import com.yd.email.feign.request.ApiEmailContactImportPageRequest;
import com.yd.email.feign.request.ApiEmailContactImportSelectAddRequest;
import com.yd.email.feign.response.ApiEmailContactImportResponse;
import com.yd.email.feign.response.ApiEmailContactImportSelectAddResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 邮箱服务-邮件联系人导入临时表信息Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailContactImportFeignFallbackFactory.class)
public interface ApiEmailContactImportFeignClient {

    /**
     * 分页查询-邮件联系人导入的列表
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiEmailContactImportPageRequest request);

    /**
     * 添加-选择联系人
     * @param request
     * @return
     */
    @PostMapping("/select/add")
    Result<ApiEmailContactImportSelectAddResponse> add(@Validated @RequestBody ApiEmailContactImportSelectAddRequest request);

    /**
     * 编辑-邮件联系人导入信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiEmailContactImportEditRequest request);

    /**
     * 详情-邮件联系人导入信息
     * @param importBizId 导入临时表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiEmailContactImportResponse> detail(@RequestParam(value = "importBizId") String importBizId);

    /**
     * 删除-邮件联系人导入信息
     * @param importBizId 导入临时表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "importBizId") String importBizId);
}
