package com.yd.email.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 联系人表（存储收件人信息）
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Getter
@Setter
@TableName("email_contact")
public class EmailContact implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 收件人唯一业务ID（联系人唯一业务ID）
     */
    @TableField("contact_biz_id")
    private String contactBizId;

    /**
     * 公司名称（保险公司等）
     */
    @TableField("company_name")
    private String companyName;

    /**
     * 联系人姓名
     */
    @TableField("name")
    private String name;

    /**
     * 联系人邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 分组名称
     */
    @TableField("group_name")
    private String groupName;

    /**
     * 类型
     */
    @TableField("type")
    private String type;

    /**
     * 称谓
     */
    @TableField("appellation")
    private String appellation;

    /**
     * 其他信息
     */
    @TableField("other")
    private String other;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
