package com.yd.email.api.controller;

import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailSendService;
import com.yd.email.feign.client.ApiEmailSendFeignClient;
import com.yd.email.feign.request.ApiSendEmailRequest;
import com.yd.email.feign.response.ApiSendEmailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/email")
@Slf4j
public class ApiEmailSendController implements ApiEmailSendFeignClient {

    @Autowired
    private ApiEmailSendService apiEmailSendService;

    /**
     * 发送邮件
     * @param request
     * @return
     */
    @Override
    public Result<ApiSendEmailResponse> sendEmail(ApiSendEmailRequest request) {
        return apiEmailSendService.sendEmail(request);
    }

//    @Autowired
//    private MailTaskMapper mailTaskMapper;
//
//    @Autowired
//    private MailRecipientMapper mailRecipientMapper;
//
//    @Autowired
//    private XxlJobService xxlJobService;
//
//    @PostMapping("/send")
//    public ResponseResult sendMail(@RequestBody MailSendRequest request) {
//        try {
//            // 1. 保存邮件任务到数据库
//            MailTask mailTask = new MailTask();
//            mailTask.setFromAddress(request.getFrom());
//            mailTask.setSubject(request.getSubject());
//            mailTask.setContent(request.getContent());
//            mailTask.setAttachmentPath(request.getAttachmentPath());
//            mailTask.setSendTime(request.getSendTime());
//            mailTask.setStatus(0);
//            mailTaskMapper.insert(mailTask);
//
//            Long taskId = mailTask.getId();
//
//            // 2. 保存收件人信息
//            for (MailSendRequest.Recipient recipient : request.getRecipients()) {
//                MailRecipient mailRecipient = new MailRecipient();
//                mailRecipient.setTaskId(taskId);
//                mailRecipient.setToAddress(recipient.getTo());
//                if (recipient.getCc() != null && !recipient.getCc().isEmpty()) {
//                    mailRecipient.setCcAddresses(String.join(",", recipient.getCc()));
//                }
//                mailRecipient.setSendStatus(0);
//                mailRecipientMapper.insert(mailRecipient);
//            }
//
//            // 3. 创建XXL-Job定时任务
//            String jobId = xxlJobService.addScheduleJob(taskId, request.getSendTime());
//
//            return ResponseResult.success("邮件任务创建成功", Map.of(
//                "taskId", taskId,
//                "jobId", jobId,
//                "scheduleTime", request.getSendTime()
//            ));
//
//        } catch (Exception e) {
//            log.error("创建邮件发送任务失败", e);
//            return ResponseResult.error("创建任务失败: " + e.getMessage());
//        }
//    }
}