package com.yd.email.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EmailVariableDto {

    /**
     * 变量唯一业务ID
     */
    private String variableBizId;

    /**
     * 变量唯一业务ID列表
     */
    private List<String> variableBizIdList;

    /**
     * 变量字段名称中文名
     */
    private String variableNameCn;

    /**
     * 变量字段名称英文名
     */
    private String variableNameEn;

    @Builder.Default
    private Boolean isExcludeMy = false;
}
