package com.yd.email.feign.request;

import lombok.Data;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class ApiEmailContactEditRequest {

    /**
     * 联系人表主键ID
     */
    @NotNull(message = "联系人表主键ID不能为空")
    private Long id;

    /**
     * 收件人唯一业务ID（联系人唯一业务ID）
     */
    @NotBlank(message = "收件人唯一业务ID不能为空")
    private String contactBizId;

    /**
     * 公司名称（保险公司等）
     */
    private String companyName;

    /**
     * 联系人姓名
     */
    @NotBlank(message = "联系人姓名不能为空")
    private String name;

    /**
     * 联系人邮箱
     */
    @NotBlank(message = "联系人邮箱不能为空")
    @Email(message = "邮箱格式不正确")
    private String email;

    /**
     * 类型
     */
    private String type;

    /**
     * 称谓
     */
    private String appellation;

    /**
     * 其他信息
     */
    private String other;

    /**
     * 关联抄送邮箱的列表
     */
    private List<String> ccEmailList;
}
