package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailSendFeignClient;
import com.yd.email.feign.request.ApiSendEmailRequest;
import com.yd.email.feign.response.ApiSendEmailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-邮件发送Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailSendFeignFallbackFactory implements FallbackFactory<ApiEmailSendFeignClient> {
    @Override
    public ApiEmailSendFeignClient create(Throwable cause) {
        return new ApiEmailSendFeignClient() {
            @Override
            public Result<ApiSendEmailResponse> sendEmail(ApiSendEmailRequest request) {
                return null;
            }
        };
    }
}
