package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailSenderConfigFeignClient;
import com.yd.email.feign.request.ApiEmailSenderConfigAddRequest;
import com.yd.email.feign.request.ApiEmailSenderConfigEditRequest;
import com.yd.email.feign.request.ApiEmailSenderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailSenderConfigDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-发件人配置信息Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailSenderConfigFeignFallbackFactory implements FallbackFactory<ApiEmailSenderConfigFeignClient> {

    @Override
    public ApiEmailSenderConfigFeignClient create(Throwable cause) {
        return new ApiEmailSenderConfigFeignClient() {
            @Override
            public Result page(ApiEmailSenderConfigPageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiEmailSenderConfigAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiEmailSenderConfigEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiEmailSenderConfigDetailResponse> detail(String senderBizId) {
                return null;
            }

            @Override
            public Result del(String senderBizId) {
                return null;
            }
        };
    }
}
