package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailProviderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailProviderConfigPageResponse;
import com.yd.email.service.dto.EmailProviderConfigDto;
import com.yd.email.service.model.EmailContact;
import com.yd.email.service.model.EmailProviderConfig;
import com.yd.email.service.dao.EmailProviderConfigMapper;
import com.yd.email.service.service.IEmailProviderConfigService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * SMTP邮箱服务商配置表（存储不同邮箱服务商的SMTP配置信息） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Service
public class EmailProviderConfigServiceImpl extends ServiceImpl<EmailProviderConfigMapper, EmailProviderConfig> implements IEmailProviderConfigService {

    @Override
    public IPage<ApiEmailProviderConfigPageResponse> page(Page<ApiEmailProviderConfigPageResponse> page,
                                                          ApiEmailProviderConfigPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param providerBizId
     * @return
     */
    @Override
    public EmailProviderConfig queryOne(String providerBizId) {
        return this.getOne(new LambdaQueryWrapper<EmailProviderConfig>()
                .eq(EmailProviderConfig::getProviderBizId,providerBizId));
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<EmailProviderConfig> queryList(EmailProviderConfigDto dto) {
        List<EmailProviderConfig> list = baseMapper.selectList(new LambdaQueryWrapper<EmailProviderConfig>()
                .eq(StringUtils.isNotBlank(dto.getProviderBizId()) && !dto.getIsExcludeMy(),EmailProviderConfig::getProviderBizId,dto.getProviderBizId())
                .eq(StringUtils.isNotBlank(dto.getProviderName()),EmailProviderConfig::getProviderName,dto.getProviderName())
                .eq(StringUtils.isNotBlank(dto.getSmtpHost()),EmailProviderConfig::getSmtpHost,dto.getSmtpHost())
                .ne(dto.getIsExcludeMy(),EmailProviderConfig::getProviderBizId,dto.getProviderBizId())
        );
        return list;
    }
}
