package com.yd.email.api.service.impl;

import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailConfigValidatorService;
import com.yd.email.service.model.EmailProviderConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import java.util.Properties;

/**
 * 验证发件人邮箱配置的合法性
 */
@Slf4j
@Service
public class ApiEmailConfigValidatorServiceImpl implements ApiEmailConfigValidatorService {

    /**
     * 测试SMTP连接
     * @param email
     * @param password
     * @param config
     * @return
     */
    @Override
    public Result testSmtpConnection(String email, String password,
                                     EmailProviderConfig config) {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", config.getStarttlsEnable() == 1 ? "true" : "false");
        props.put("mail.smtp.host", config.getSmtpHost());
        props.put("mail.smtp.port", config.getSmtpPort());
        props.put("mail.smtp.connectiontimeout", "10000");
        props.put("mail.smtp.timeout", "15000");
        
        // SSL配置
        if ("465".equals(config.getSmtpPort())) {
            props.put("mail.smtp.socketFactory.port", config.getSmtpPort());
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        
        Session session = Session.getInstance(props);
        
        try {
            Transport transport = session.getTransport("smtp");
            transport.connect(config.getSmtpHost(), email, password);
            
            boolean isConnected = transport.isConnected();
            transport.close();
            
            if (isConnected) {
                return Result.success("验证成功");
            } else {
                throw new BusinessException("SMTP连接测试失败");
            }
            
        } catch (AuthenticationFailedException e) {
            throw new BusinessException("认证失败：请检查邮箱地址和授权码是否正确");
        } catch (MessagingException e) {
            throw new BusinessException("连接失败"+ e.getMessage());
        }
    }

    /**
     * 邮箱格式验证
     * @param email
     * @return
     */
    private boolean isValidEmailFormat(String email) {
        String emailRegex = "^[A-Za-z0-9+_.-]+@(.+)$";
        return email != null && email.matches(emailRegex);
    }

}