package com.yd.email.feign.request;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class ApiEmailContactImportEditRequest {

    /**
     * 导入临时表主键ID
     */
    @NotNull(message = "导入临时表主键ID不能为空")
    private Long id;

    /**
     * 导入临时表唯一业务ID
     */
    @NotBlank(message = "导入临时表唯一业务ID不能为空")
    private String importBizId;

    /**
     * 收件人邮箱（单个）
     */
    @NotBlank(message = "收件人邮箱不能为空")
    private String receiveEmail;

    /**
     * 抄送人邮箱（数组）
     */
    @NotEmpty(message = "抄送人邮箱不能为空")
    private List<String> ccEmailList;
}
