package com.yd.email.feign.request;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

@Data
public class ApiSendEmailRequest {

    /**
     * 发件人唯一业务ID
     */
    private String senderBizId;

    /**
     * 发件人邮箱（单个）
     */
    @NotBlank(message = "发件人邮箱不能为空")
    private String sendEmail;

    /**
     * 邮件主题
     */
    @NotBlank(message = "邮件主题不能为空")
    private String subject;

    /**
     * 邮件内容
     */
    @NotBlank(message = "邮件内容不能为空")
    private String content;

    /**
     * 计划发送时间（为空表示立即发送，不为空表示定时发送）
     */
    private LocalDateTime scheduleTime;

    /**
     * 发送邮件的附件路径（多个用分号分隔）
     */
    private String attachmentPath;

//    /**
//     * 收件人列表信息
//     */
//    private List<ApiEmailTaskRecipientsDto> recipientsDtoList;

    //===========以下是附加传入字段=============
    /**
     * 变量分组唯一业务ID
     */
    @NotBlank(message = "变量分组唯一业务ID不能为空")
    private String variableGroupBizId;

    /**
     * 导入临时表的当前会话id（前端使用，用于查询。存于前端缓存）（冗余字段，选择联系人和导入联系人excel都有值，用于发送到哪些收件人的，查询导入临时表的依据）
     */
    @NotBlank(message = "会话id不能为空")
    private String sessionId;

//    /**
//     * 邮件内容的填充的变量字段（数组，英文字段名）
//     */
//    private List<String> fillVariableList;

}
