package com.yd.email.api.service.impl;

import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailContactCcService;
import com.yd.email.feign.dto.ApiEmailContactCcDto;
import com.yd.email.feign.enums.RecipientTypeEnum;
import com.yd.email.service.dto.EmailContactCcDto;
import com.yd.email.service.model.EmailContactCc;
import com.yd.email.service.service.IEmailContactCcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 收件人和抄送密送关联信息
 */
@Slf4j
@Service
public class ApiEmailContactCcServiceImpl implements ApiEmailContactCcService {

    @Autowired
    private IEmailContactCcService iEmailContactCcService;

    /**
     * 保存收件人和抄送密送关联信息集合
     * @param dtoList
     * @param contactBizId
     * @return
     */
    @Override
    public Result saveEmailContactCcList(List<ApiEmailContactCcDto> dtoList, String contactBizId){
        //先删后增加
        //根据联系人业务id删除关系
        iEmailContactCcService.delByContactBizId(contactBizId);

        if (!CollectionUtils.isEmpty(dtoList)){
            //新增关系
            List<EmailContactCc> saveList = dtoList.stream().map(dto -> {
                EmailContactCc emailContactCc = new EmailContactCc();
                BeanUtils.copyProperties(dto,emailContactCc);
                emailContactCc.setContactBizId(contactBizId);
                return emailContactCc;
            }).collect(Collectors.toList());

            iEmailContactCcService.saveOrUpdateBatch(saveList);
        }

        return Result.success();
    }

    /**
     * 获取抄送人邮箱列表
     * @param contactBizId
     * @return
     */
    @Override
    public Result<List<String>> getEmailContactCcList(String contactBizId) {
        List<String> stringList = new ArrayList<>();
        List<EmailContactCc> list = iEmailContactCcService.queryList(EmailContactCcDto
                .builder()
                .type(RecipientTypeEnum.TCC.getItemValue())
                .contactBizId(contactBizId)
                .build());
        if (!CollectionUtils.isEmpty(list)) {
            stringList = list.stream().map(EmailContactCc::getEmail).collect(Collectors.toList());
        }
        return Result.success(stringList);
    }
}
