package com.yd.email.feign.request;

import com.yd.email.feign.dto.ApiEmailTaskRecipientsDto;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiSendEmailRequest {

    /**
     * 发件人唯一业务ID
     */
    private String senderBizId;

    /**
     * 发件人邮箱（单个）
     */
    @NotBlank(message = "发件人邮箱不能为空")
    private String sendEmail;

    /**
     * 邮件主题
     */
    @NotBlank(message = "邮件主题不能为空")
    private String subject;

    /**
     * 邮件内容
     */
    @NotBlank(message = "邮件内容不能为空")
    private String content;

    /**
     * 计划发送时间（为空表示立即发送，不为空表示定时发送）
     */
    private LocalDateTime scheduleTime;

    /**
     * 发送邮件的附件路径（多个用分号分隔）
     */
    private String attachmentPath;

    /**
     * 收件人列表信息
     */
    private List<ApiEmailTaskRecipientsDto> recipientsDtoList;
}
