package com.yd.email.api.controller;

import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailSendService;
import com.yd.email.feign.client.ApiEmailSendFeignClient;
import com.yd.email.feign.request.ApiSendEmailRequest;
import com.yd.email.feign.response.ApiSendEmailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/email")
@Slf4j
public class ApiEmailSendController implements ApiEmailSendFeignClient {

    @Autowired
    private ApiEmailSendService apiEmailSendService;

    /**
     * 发送邮件
     * @param request
     * @return
     */
    @Override
    public Result<ApiSendEmailResponse> sendEmail(ApiSendEmailRequest request) {
        return apiEmailSendService.sendEmail(request);
    }
}