package com.yd.email.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EmailSenderConfigDto {

    /**
     * 发件人唯一业务ID
     */
    private String senderBizId;

    /**
     * 邮箱地址
     */
    private String email;

    /**
     * 查询是否排除当前发件人唯一标识数据，默认false不排除，true的话senderBizId必传
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
