package com.yd.email.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EmailProviderConfigDto {

    /**
     * 邮箱服务商唯一业务ID
     */
    private String providerBizId;

    /**
     * 邮箱服务商名称
     */
    private String providerName;

    /**
     * SMTP服务器地址
     */
    private String smtpHost;

    @Builder.Default
    private Boolean isExcludeMy = false;
}
