package com.yd.email.feign.response;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiEmailProviderConfigDetailResponse {

    /**
     * 邮箱服务商主键ID
     */
    private Long id;

    /**
     * 邮箱服务商唯一业务ID
     */
    private String providerBizId;

    /**
     * 邮箱服务商名称
     */
    private String providerName;

    /**
     * SMTP服务器地址
     */
    private String smtpHost;

    /**
     * SMTP服务器端口
     */
    private Integer smtpPort;

    /**
     * 是否启用SSL加密: 0-否, 1-是
     */
    private Integer sslEnabled;

    /**
     * 配置描述
     */
    private String description;

    /**
     * 是否为默认配置: 0-否, 1-是
     */
    private Integer isDefault;

    /**
     * 是否启用: 0-否, 1-是
     */
    private Integer isActive;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
