package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailProviderConfigFeignClient;
import com.yd.email.feign.request.ApiEmailProviderConfigAddRequest;
import com.yd.email.feign.request.ApiEmailProviderConfigEditRequest;
import com.yd.email.feign.request.ApiEmailProviderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailProviderConfigDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-SMTP邮箱服务商配置信息Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailProviderConfigFeignFallbackFactory implements FallbackFactory<ApiEmailProviderConfigFeignClient> {
    @Override
    public ApiEmailProviderConfigFeignClient create(Throwable cause) {
        return new ApiEmailProviderConfigFeignClient() {
            @Override
            public Result page(ApiEmailProviderConfigPageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiEmailProviderConfigAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiEmailProviderConfigEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiEmailProviderConfigDetailResponse> detail(String providerBizId) {
                return null;
            }

            @Override
            public Result del(String providerBizId) {
                return null;
            }
        };
    }
}
