package com.yd.email.feign.request;

import lombok.Data;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;

@Data
public class ApiEmailSenderValidateRequest {

    /**
     * 邮箱地址
     */
    @NotBlank(message = "邮箱地址不能为空")
    @Email(message = "邮箱格式不正确")
    private String email;

    /**
     * 邮箱密码或授权码
     */
    @NotBlank(message = "邮箱密码或授权码不能为空")
    private String password;

    /**
     * 绑定的邮箱服务商唯一业务ID
     */
    @NotBlank(message = "绑定的邮箱服务商唯一业务ID不能为空")
    private String providerBizId;


}
