package com.yd.email.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EmailContactImportDto {

    /**
     * 导入临时表唯一业务ID
     */
    private String importBizId;

    /**
     * 当前会话id（前端使用，用于查询。存于前端缓存）
     */
    private String sessionId;

    /**
     * 收件人邮箱（单个）
     */
    private String receiveEmail;

    @Builder.Default
    private Boolean isExcludeMy = false;
}
