package com.yd.email.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 邮件任务表（存储邮件发送任务信息）
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Getter
@Setter
@TableName("email_task")
public class EmailTask implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 邮件任务唯一业务ID
     */
    @TableField("task_biz_id")
    private String taskBizId;

    /**
     * 任务名称
     */
    @TableField("task_name")
    private String taskName;

    /**
     * 关联发件人唯一业务ID
     */
    @TableField("sender_biz_id")
    private String senderBizId;

    /**
     * 发件人邮箱（单个）
     */
    @TableField("send_email")
    private String sendEmail;

    /**
     * 邮件主题
     */
    @TableField("subject")
    private String subject;

    /**
     * 邮件内容
     */
    @TableField("content")
    private String content;

    /**
     * 是否为HTML格式: 0-否, 1-是（字典）
     */
    @TableField("is_html")
    private Integer isHtml;

    /**
     * 任务状态：PENDING-待发送, SENDING-发送中, COMPLETED-已完成, FAILED-发送失败, CANCELLED-已取消
     */
    @TableField("status")
    private String status;

    /**
     * 计划发送时间（为空表示立即发送，不为空表示定时发送）
     */
    @TableField("schedule_time")
    private LocalDateTime scheduleTime;

    /**
     * 实际发送时间（发送成功的时间）
     */
    @TableField("send_time")
    private LocalDateTime sendTime;

    /**
     * 发送邮件的附件路径（多个用分号分隔）
     */
    @TableField("attachment_path")
    private String attachmentPath;

    /**
     * 变量分组唯一业务ID
     */
    @TableField("variable_group_biz_id")
    private String variableGroupBizId;

    /**
     * 邮件内容的填充的变量字段（数组分号分隔，英文字段名）
     */
    @TableField("fill_variable")
    private String fillVariable;

    /**
     * 导入临时表的当前会话id（前端使用，用于查询。存于前端缓存）（冗余字段，选择联系人和导入联系人excel都有值）
     */
    @TableField("session_id")
    private String sessionId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
